% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amaretto_functions.R
\name{AMARETTO_EvaluateTestSet}
\alias{AMARETTO_EvaluateTestSet}
\title{AMARETTO_EvaluateTestSet}
\usage{
AMARETTO_EvaluateTestSet(AMARETTOresults = AMARETTOresults,
  MA_Data_TestSet = MA_Data_TestSet,
  RegulatorData_TestSet = RegulatorData_TestSet)
}
\arguments{
\item{AMARETTOresults}{AMARETTO output from AMARETTO_Run().}

\item{MA_Data_TestSet}{Gene expression matrix from a test set (that was not used in AMARETTO_Run()).}

\item{RegulatorData_TestSet}{Test regulator data from CreateRegulatorData().}
}
\value{
result
}
\description{
Code to evaluate AMARETTO on a new gene expression test set. Uses output from AMARETTO_Run() and CreateRegulatorData().
}
\examples{
data('ProcessedDataLIHC')
AMARETTOinit <- AMARETTO_Initialize(ProcessedData = ProcessedDataLIHC,
                                    NrModules = 2, VarPercentage = 50)

AMARETTOresults <- AMARETTO_Run(AMARETTOinit)
AMARETTOtestReport <- AMARETTO_EvaluateTestSet(AMARETTOresults = AMARETTOresults,
                                               MA_Data_TestSet = AMARETTOinit$MA_matrix_Var,
                                               RegulatorData_TestSet = AMARETTOinit$RegulatorData)
}
