% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amaretto_functions.R
\name{AMARETTO_Initialize}
\alias{AMARETTO_Initialize}
\title{AMARETTO_Initialize (version: reorder and filter MA_Matrix)}
\usage{
AMARETTO_Initialize(ProcessedData = ProcessedData, Driver_list = NULL,
  NrModules, VarPercentage, PvalueThreshold = 0.001,
  RsquareThreshold = 0.1, pmax = 10, NrCores = 1, OneRunStop = 0,
  method = "union", random_seeds = NULL, convergence_cutoff = 0.01)
}
\arguments{
\item{ProcessedData}{List of Expression, CNV and MethylMix data matrices, with genes in rows and samples in columns.}

\item{Driver_list}{Custom list of driver genes to be considered in analysis}

\item{NrModules}{How many gene co-expression modules should AMARETTO search for? Usually around 100 is acceptable, given the large number of possible driver-passenger gene combinations.}

\item{VarPercentage}{Minimum percentage by variance for filtering of genes; for example, 75\% would indicate that the CreateRegulatorData() function only analyses genes that have a variance above the 75th percentile across all samples.}

\item{PvalueThreshold}{Threshold used to find relevant driver genes with CNV alterations: maximal p-value.}

\item{RsquareThreshold}{Threshold used to find relevant driver genes with CNV alterations: minimal R-square value between CNV and gene expression data.}

\item{pmax}{'pmax' variable for glmnet function from glmnet package; the maximum number of variables aver to be nonzero. Should not be changed by user unless she/he fully understands the AMARETTO algorithm and how its parameters choices affect model output.}

\item{NrCores}{A numeric variable indicating the number of computer/server cores to use for paralellelization. Default is 1, i.e. no parallelization. Please check your computer or server's computing capacities before increasing this number.  Parallelization is done via the RParallel package. Mac vs. Windows environments may behave differently when using parallelization.}

\item{OneRunStop}{OneRunStop}

\item{method}{Perform union or intersection of the driver genes evaluated from the input data matrices and custom driver gene list provided.}

\item{random_seeds}{A numeric vector of length 2, containing two seed numbers for randomization : 1st for kmeans and 2nd for glmnet}

\item{convergence_cutoff}{A numeric value (E.g. 0.01) representing the fraction of the total number of genes, in which, The algorithm is considered reaching convergence and will stop, if Nr of Gene-replacements in an iteration falls below this threshold * total number of genes.}
}
\value{
result
}
\description{
Code used to initialize the seed clusters for an AMARETTO run.
Requires processed gene expressiosn (rna-seq or microarray), CNV (usually from a GISTIC run), and methylation (from MethylMix, provided in this package) data.
Uses the function CreateRegulatorData() and results are fed into the function AMARETTO_Run().
}
\examples{
data('ProcessedDataLIHC')
data('Driver_Genes')
AMARETTOinit <- AMARETTO_Initialize(ProcessedData = ProcessedDataLIHC,
                                    NrModules = 2, VarPercentage = 50)
\dontrun{
AMARETTOinit <- AMARETTO_Initialize(ProcessedData = ProcessedDataLIHC,
                                    Driver_list = Driver_Genes[['MSigDB']],
                                    NrModules = 2, VarPercentage = 50)
}
}
