% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{normaliseSpectra}
\alias{normaliseSpectra}
\title{Normalisation}
\usage{
normaliseSpectra(spectra, type.norm = "CS", verbose = TRUE, ...)
}
\arguments{
\item{spectra}{Data frame with spectra in columns and chemical shifts in
rows. Colnames of this data frame correspond to pure metabolite names and
rownames to chemical shift grid (in ppm).}

\item{type.norm}{Type of normalisation : "CS", "mean", "pqn", "median",
"firstquartile" or "peak". Default to "CS".}

\item{verbose}{A boolean value to allow print out process information.}

\item{...}{other arguments to be passed to
\code{\link[PepsNMR]{Normalization}}}
}
\value{
A data frame with normalised spectra in columns and chemical shifts
(in ppm) in rows.
}
\description{
Normalise a data frame of spectra to a constant sum (CS) or with a
method of \code{PepsNMR} package (see \code{\link[PepsNMR]{Normalization}}).
}
\examples{
current_path <- system.file("extdata", package = "ASICS")
spectra_data <- importSpectra(name.dir = current_path,
                     name.file = "spectra_example.txt", type.import = "txt")
spectra_norm <- normaliseSpectra(spectra_data, type.norm = "pqn")
}
