% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_dataframe3D}
\alias{plot_dataframe3D}
\title{Visualize a three-dimensional data with labels and colors.}
\usage{
plot_dataframe3D(
  dataframe3D = NULL,
  labels = NULL,
  colors = NULL,
  theta = 30,
  phi = 30,
  title = "",
  xlabel = "",
  ylabel = "",
  zlabel = ""
)
}
\arguments{
\item{dataframe3D}{A dataframe with three columns.}

\item{labels}{NULL or a vector of labels of all the samples,
corresponding to colors.}

\item{colors}{NULL or a vector of colors of all the samples,
corresponding to labels.}

\item{theta}{Angle of the plot.}

\item{phi}{Angle of the plot.}

\item{title}{Title.}

\item{xlabel}{x-axis label.}

\item{ylabel}{y-axis label.}

\item{zlabel}{z-axis label.}
}
\value{
A scatter3D object in plot3D package.
}
\description{
This function visualizes a three-dimensional data with labels and colors.
}
\examples{
data(pbmcs_eg)
mat <- SingleCellExperiment::reducedDim(pbmcs_eg$CM, "UMAP")[, 1:3]
dataframe3D <- as.data.frame(mat)
labels <- SummarizedExperiment::colData(pbmcs_eg$CM)$seurat_clusters
plot_dataframe3D(dataframe3D = dataframe3D, labels = labels, colors = NULL,
                 theta = 45, phi = 20, title = "PBMC (CO & MSigDB)",
                 xlabel = "UMAP_1", ylabel = "UMAP_2", zlabel = "UMAP_3")

}
