% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{ASEset-scanForHeterozygotes}
\alias{ASEset-scanForHeterozygotes}
\alias{scanForHeterozygotes}
\alias{scanForHeterozygotes,ASEset-method}
\alias{scanForHeterozygotes,GAlignmentsList-method}
\title{scanForHeterozygotes}
\usage{
scanForHeterozygotes(BamList, ...)

\S4method{scanForHeterozygotes}{GAlignmentsList}(
  BamList,
  minimumReadsAtPos = 20,
  maximumMajorAlleleFrequency = 0.9,
  minimumMinorAlleleFrequency = 0.1,
  minimumBiAllelicFrequency = 0.9,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{BamList}{A \code{GAlignmentsList object}}

\item{...}{argument to pass on}

\item{minimumReadsAtPos}{minimum number of reads required to call a SNP at a
given position}

\item{maximumMajorAlleleFrequency}{maximum frequency allowed for the most
common allele. Setting this parameter lower will minimise the SNP calls
resulting from technical read errors, at the cost of missing loci with
potential strong ASE}

\item{minimumMinorAlleleFrequency}{minimum frequency allowed for the second most
common allele. Setting this parameter higher will minimise the SNP calls
resulting from technical read errors, at the cost of missing loci with
potential strong ASE}

\item{minimumBiAllelicFrequency}{minimum frequency allowed for the first and
second most common allele. Setting a Lower value for this parameter will
minimise the identification of loci with three or more alleles in one
sample. This is useful if sequencing errors are suspected to be common.}

\item{verbose}{logical indicating if process information should be displayed}
}
\value{
\code{scanForHeterozygotes} returns a GRanges object with the SNPs
for the BamList object that was used as input.
}
\description{
Identifies the positions of SNPs found in BamGR reads.
}
\details{
This function scans all reads stored in a \code{GAlignmentsList} for
possible heterozygote positions. The user can balance the sensitivity of the
search by modifying the minimumReadsAtPos, maximumMajorAlleleFrequency and
minimumBiAllelicFrequency arguments.
}
\examples{

data(reads)
s <- scanForHeterozygotes(reads,verbose=FALSE)

}
\seealso{
\itemize{ \item The \code{\link{getAlleleCounts}} which is a
function that count the number of reads overlapping a site.  }
}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{SNP}
\keyword{heterozygote}
\keyword{scan}
