% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq.test-methods.R
\docType{methods}
\name{chisq.test}
\alias{chisq.test}
\alias{chisq.test,ASEset-method}
\title{chi-square test}
\usage{
\S4method{chisq.test}{ASEset}(x, y = "*")
}
\arguments{
\item{x}{\code{ASEset} object}

\item{y}{strand option}
}
\value{
\code{chisq.test} returns a matrix with the chisq.test P-value for
each SNP and sample
}
\description{
Performs a chisq.test on an ASEset object.
}
\details{
The test is performed on one strand in an ASEset object.
}
\examples{

#load example data
data(ASEset)

#make a chi-square test on default non-stranded strand 
chisq.test(ASEset)

}
\seealso{
\itemize{ \item The \code{\link{binom.test}} which is another test
that can be applied on an \link{ASEset} object.  }
}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{chi-square}
\keyword{test}
