% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-methods.R
\docType{methods}
\name{multiAllelicFilt}
\alias{multiAllelicFilt}
\alias{multiAllelicFilt,ASEset-method}
\title{multi-allelic filter methods}
\usage{
multiAllelicFilt(x, ...)

\S4method{multiAllelicFilt}{ASEset}(
  x,
  strand = "*",
  threshold.count.sample = 10,
  threshold.frequency = 0.1,
  filterOver = "eachSample"
)
}
\arguments{
\item{x}{\code{ASEset} object}

\item{...}{internal param}

\item{strand}{strand to infer from}

\item{threshold.count.sample}{least amount of counts to try to infer allele}

\item{threshold.frequency}{least fraction to classify (see details)}

\item{filterOver}{'eachSample' or 'allSamples'}
}
\description{
filter on multiallelic snps
}
\details{
based on the allele counts for all four variants A, T, G and C and returns true 
if there is counts enough suggesting a third or more alleles. The sensitivity can 
be specified using 'threshold.count.sample' and 'threshold.frequency'.
}
\examples{

#load example data
data(ASEset)
a <- ASEset

multiAllelicFilt(a)

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{filter}
