% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_helpers.R
\name{nmr_pca_outliers_filter}
\alias{nmr_pca_outliers_filter}
\title{Exclude outliers}
\usage{
nmr_pca_outliers_filter(nmr_dataset, pca_outliers)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D} object}

\item{pca_outliers}{The output from \code{\link[=nmr_pca_outliers]{nmr_pca_outliers()}}}
}
\value{
An \link{nmr_dataset_1D} without the detected outliers
}
\description{
Exclude outliers
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
model <- nmr_pca_build_model(dataset_1D)
outliers_info <- nmr_pca_outliers(dataset_1D, model)
dataset_whitout_outliers <- nmr_pca_outliers_filter(dataset_1D, outliers_info)

}
\seealso{
Other PCA related functions: 
\code{\link{nmr_pca_build_model}()},
\code{\link{nmr_pca_outliers}()},
\code{\link{nmr_pca_outliers_plot}()},
\code{\link{nmr_pca_outliers_robust}()},
\code{\link{nmr_pca_plots}}

Other outlier detection functions: 
\code{\link{Pipelines}},
\code{\link{nmr_pca_outliers}()},
\code{\link{nmr_pca_outliers_plot}()},
\code{\link{nmr_pca_outliers_robust}()}

Other subsetting functions: 
\code{\link{[.nmr_dataset}()},
\code{\link{[.nmr_dataset_1D}()},
\code{\link{[.nmr_dataset_peak_table}()},
\code{\link{filter.nmr_dataset_family}()}
}
\concept{PCA related functions}
\concept{outlier detection functions}
\concept{subsetting functions}
