% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avnotebooks-methods.R
\name{avnotebooks-methods}
\alias{avnotebooks-methods}
\alias{avnotebooks,missing-method}
\alias{avnotebooks,ANY-method}
\alias{avnotebooks_localize,missing-method}
\alias{avnotebooks_localize,ANY-method}
\alias{avnotebooks_delocalize,missing-method}
\alias{avnotebooks_delocalize,ANY-method}
\title{All the notebook type methods for AnVIL}
\usage{
\S4method{avnotebooks}{missing}(..., platform)

\S4method{avnotebooks}{ANY}(..., platform)

\S4method{avnotebooks_localize}{missing}(..., platform)

\S4method{avnotebooks_localize}{ANY}(..., platform)

\S4method{avnotebooks_delocalize}{missing}(..., platform)

\S4method{avnotebooks_delocalize}{ANY}(..., platform)
}
\arguments{
\item{...}{Arguments passed to the methods.}

\item{platform}{A Platform derived class indicating the AnVIL environment,
currently, \code{azure} and \code{gcp} classes are compatible.}
}
\value{
Methods for the 'missing' and 'ANY' signatures provide a way to
redirect calls to the appropriate method for the current cloud platform.
}
\description{
These are the methods to be used by the AnVIL package.
}
\section{Functions}{
\itemize{
\item \code{avnotebooks(missing)}: List the available notebooks in the current
workspace

\item \code{avnotebooks(ANY)}: List the available notebooks in the current
workspace

\item \code{avnotebooks_localize(missing)}: sync the contents of the workspace storage to
the local file system

\item \code{avnotebooks_localize(ANY)}: sync the contents of the workspace storage to
the local file system

\item \code{avnotebooks_delocalize(missing)}: sync the contents of the local file system to
the workspace storage

\item \code{avnotebooks_delocalize(ANY)}: sync the contents of the local file system to
the workspace storage

}}
\examples{
findMethods("avnotebooks")
getMethod("avnotebooks", c(platform = "missing"))

}
