% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_ShowFit.R
\name{BASiCS_ShowFit}
\alias{BASiCS_ShowFit}
\alias{BASiCS_showFit}
\title{Plotting the trend after Bayesian regression}
\usage{
BASiCS_ShowFit(
  object,
  xlab = "log(mu)",
  ylab = "log(delta)",
  pch = 16,
  smooth = TRUE,
  variance = 1.2,
  colour = "dark blue",
  markExcludedGenes = TRUE,
  GenesSel = NULL,
  colourGenesSel = "dark red",
  Uncertainty = TRUE
)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{BASiCS_Chain}}}

\item{xlab}{As in \code{\link[graphics]{par}}.}

\item{ylab}{As in \code{\link[graphics]{par}}.}

\item{pch}{As in \code{\link[graphics]{par}}. Default value \code{pch = 16}.}

\item{smooth}{Logical to indicate wether the smoothScatter function is used
to plot the scatter plot. Default value \code{smooth = TRUE}.}

\item{variance}{Variance used to build GRBFs for regression. Default value
\code{variance = 1.2}}

\item{colour}{colour used to denote genes within the scatterplot. Only used 
when \code{smooth = TRUE}. Default value 
\code{colour = "dark blue"}.}

\item{markExcludedGenes}{Whether or not lowly expressed genes that were
excluded from the regression fit are included in the scatterplot.
Default value \code{markExcludedGenes = TRUE}.}

\item{GenesSel}{Vector of gene names to be highlighted in the scatterplot.
Only used when \code{smooth = TRUE}. Default value \code{GenesSel = NULL}.}

\item{colourGenesSel}{colour used to denote the genes listed in 
\code{GenesSel} within the scatterplot. Default value 
\code{colourGenesSel = "dark red"}.}

\item{Uncertainty}{logical indicator. If true, statistical uncertainty
around the regression fit is shown in the plot.}
}
\value{
A ggplot2 object
}
\description{
Plotting the trend after Bayesian regression using a
\code{\linkS4class{BASiCS_Chain}} object
}
\examples{
data(ChainRNAReg)
BASiCS_ShowFit(ChainRNAReg)

}
\references{
Eling et al (2018). Cell Systems
https://doi.org/10.1016/j.cels.2018.06.011
}
\author{
Nils Eling \email{eling@ebi.ac.uk}

Catalina Vallejos \email{cnvallej@uc.cl}
}
