% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_Dataset.R
\name{generate_dataset}
\alias{generate_dataset}
\title{Generate dataset with batch-effects and biological labels using
a simple LS model}
\usage{
generate_dataset(
  features,
  batches,
  samplesperbatch,
  mvstmt,
  classes,
  housekeeping = NULL,
  deterministic = FALSE
)
}
\arguments{
\item{features}{Integer indicating the number of features
(e.g. genes/proteins) in the dataset.}

\item{batches}{Integer indicating the number of batches in the
dataset.}

\item{samplesperbatch}{Integer indicating the number of of samples
per batch.}

\item{mvstmt}{Float (in [0,1)) indicating the fraction of missing values
per batch.}

\item{classes}{Integer indicating the number of classes in the dataset.}

\item{housekeeping}{If NULL, no huosekeeping features will be simulatd.
Else, housepeeping indicates the fraction of of housekeeping features.}

\item{deterministic}{Whether to assigns the classes deterministically,
instead of random sampling}
}
\value{
A dataframe containing the simulated data.
}
\description{
The data will be already in the correct format for BERT.
}
\examples{
# generate dataset with 1000 features, 5 batches, 10 samples per batch and
# two genotypes
data = generate_dataset(1000,5,10, 0.1, 2)
}
