% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalysis.R
\name{addCLT}
\alias{addCLT}
\title{The additive method for meta-analysis}
\usage{
addCLT(x)
}
\arguments{
\item{x}{is an array of independent p-values}
}
\value{
combined p-value
}
\description{
Combine independent studies using the average of p-values
}
\details{
This method is based on the fact that sum of independent uniform variables 
follow the Irwin-Hall distribution [1a,1b]. When the number of p-values 
is small (\emph{n<20}), the distribution of the average of p-values can 
be calculated using a linear transformation of the Irwin-Hall distribution.
When \emph{n} is large, the distribution is approximated using the 
Central Limit Theorem to avoid underflow/overflow problems [2,3,4,5].
}
\examples{

x <- rep(0,10)
addCLT(x)

x <- runif(10)
addCLT(x)

}
\author{
Tin Nguyen and Sorin Draghici
}
\references{
[1a] P. Hall. The distribution of means for samples of size n drawn from a 
population in which the variate takes values between 0 and 1, all such 
values being equally probable. Biometrika, 19(3-4):240-244, 1927.

[1b] J. O. Irwin. On the frequency distribution of the means of samples 
from a population having any law of frequency with finite moments, with 
special reference to Pearson's Type II. Biometrika, 19(3-4):225-239, 1927.

[2] T. Nguyen, R. Tagett, M. Donato, C. Mitrea, and S. Draghici. A novel 
bi-level meta-analysis approach -- applied to biological pathway analysis. 
Bioinformatics, 32(3):409-416, 2016.

[3] T. Nguyen, C. Mitrea, R. Tagett, and S. Draghici. DANUBE: Data-driven 
meta-ANalysis using UnBiased Empirical distributions -- applied to 
biological pathway analysis. Proceedings of the IEEE, PP(99):1-20, 2016.

[4] T. Nguyen, D. Diaz, R. Tagett, and S. Draghici. Overcoming the 
matched-sample bottleneck: an orthogonal approach to integrate omic data. 
Scientific Reports, 6:29251, 2016.

[5] T. Nguyen, D. Diaz, and S. Draghici. TOMAS: A novel TOpology-aware 
Meta-Analysis approach applied to System biology. In Proceedings of the 
7th ACM International Conference on Bioin- formatics, Computational Biology, 
and Health Informatics, pages 13-22. ACM, 2016.
}
\seealso{
\code{\link{fisherMethod}}, \code{\link{stoufferMethod}}
}

