% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathwayAnalysis.R
\name{loadKEGGPathways}
\alias{loadKEGGPathways}
\title{Load KEGG pathways and names}
\usage{
loadKEGGPathways(organism = "hsa", updateCache = FALSE)
}
\arguments{
\item{organism}{organism code. Default value is "hsa" (human)}

\item{updateCache}{re-download KEGG pathways. Default value is FALSE}
}
\value{
A list of the following components
\itemize{
\item \emph{kpg} a list of \code{\link{graphNEL}} objects 
encoding the pathway information. 
\item \emph{kpn} a named vector of pathway tiles. 
The names of the vector are the pathway KEGG IDs.
}
}
\description{
Load KEGG pathways and names
}
\examples{
x <- loadKEGGPathways()
}
\author{
Tin Nguyen and Sorin Draghici
}
\seealso{
\code{\link{keggPathwayGraphs}}, \code{\link{keggPathwayNames}}
}

