% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annots_from_fa.R
\name{annots_from_fa_df}
\alias{annots_from_fa_df}
\alias{annots_from_fa_GRanges}
\title{Get genome annotation from Ensembl FASTA file}
\usage{
annots_from_fa_df(file)

annots_from_fa_GRanges(file)
}
\arguments{
\item{file}{Path to the FASTA file to be read. The file can remain gzipped.}
}
\value{
\code{annots_from_fa_df} returns a data frame and
\code{annots_from_fa_GRanges} returns \code{GRanges}.

A data frame with genome annotations.
}
\description{
Ensembl FASTA files for RNA contain much of the information contained in GTF
files, such as chromosome, genome assembly version, coordinates, strand,
gene ID, gene symbol, and gene description. Given such a FASTA file, this
function can extract all the genome annotation information and return a
data frame or a \code{GRanges} object.
}
\examples{
fn <- system.file("testdata/fasta_test.fasta", package = "BUSpaRse")
annots_from_fa_df(fn)
annots_from_fa_GRanges(fn)

}
