% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCellProcessedData.R
\name{getCellProcessedData}
\alias{getCellProcessedData}
\title{Retrieve Bgee processed expression values at cell level for single cell data in Bgee.}
\usage{
getCellProcessedData(myBgeeObject, experimentId, package = "zellkonverter")
}
\arguments{
\item{myBgeeObject}{A Reference Class Bgee object, notably specifying the targeted species
and data type.}

\item{experimentId}{Filter allowing to specify one ArrayExpress or GEO accession, e.g.,
GSE43721. Can not be null}

\item{package}{Name of the R package used to load the H5AD cell data. It can either be \"anndata\"
or \"zellkonverter\". If zellkonverter is used then its default reader (R) is used.}
}
\description{
This function loads the processed gene count matrix of single cell experiments in Bgee.
These data are available for all droplet based single-cell RNA-seq and full length single-cell RNA-seq.
These files are stored in the H5AD format.
}
\examples{
{
\dontrun{
  bgee <- Bgee$new(species = "Gallus_gallus", dataType = "sc_droplet_based")
  cellProcessedData <- getCellProcessedData(bgee, experimentId = "ERP132576")
}
}

}
\author{
Julien Wollbrett
}
