% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{estimateBsWidthPlot}
\alias{estimateBsWidthPlot}
\title{Plot the signal-to-flank score for varying gene-wise filter and binding
site width}
\usage{
estimateBsWidthPlot(object)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the the signal-to-flank score as a mean
for each binding site width and gene-wise filter as indicated when executing
\code{\link{estimateBsWidth}}. Additionally a mean of means visualizes the
overall trend and a red line indicates the suggested optimal binding site
width. The function \code{\link{estimateBsWidth}} is expected to be
executed prior to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])
bds = estimateBsWidth(bds, anno.genes = gns, est.maxBsWidth = 19,
 geneResolution = "coarse", bsResolution = "coarse", est.subsetChromosome = "chr22")
estimateBsWidthPlot(bds)
}
\seealso{
\code{\link{estimateBsWidth}}
}
