% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCentrality.R
\name{getGNP}
\alias{getGNP}
\title{Generate random graph from reference}
\usage{
getGNP(gg, ...)
}
\arguments{
\item{gg}{reference graph}

\item{...}{additional arguments to be passed to
\code{\link[igraph]{sample_gnp}}}
}
\value{
new instance of the random graph.
}
\description{
Function generates random G(n,p) Erdos-Renyi graph
(\code{\link[igraph]{sample_gnp}}) with the same number of vertices and
edges as in in the reference graph \code{gg}.
}
\examples{
data(karate,package='igraphdata')
vcount(karate)
ecount(karate)
rg<- getGNP(karate)
vcount(rg)
ecount(rg)
}
