% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{plot_Ic_Simulation}
\alias{plot_Ic_Simulation}
\title{Line or boxplot of an observed and its simulated scores}
\usage{
plot_Ic_Simulation(
  Ic,
  simulation,
  las = 0,
  ylim = NULL,
  order = NULL,
  main = NULL,
  ylab = "Ic",
  fun = c("matplot", "boxplot"),
  which2point = NULL
)
}
\arguments{
\item{Ic}{A vector with names of states. If order is not assigned,
then plot by the order of this vector.}

\item{simulation}{A numeric matrix of Ic scores in which rows are states and columns are numbers of simulated times.
It can be obtained from \code{\link{simulation_Ic}}}

\item{las}{Numeric in {0, 1, 2, 3}; the style of axis labels.
Default is 0,  meaning labels are parallel.
(link to http://127.0.0.1:21580/library/graphics/html/par.html).}

\item{ylim}{An integer vector of length 2. Default is NULL.}

\item{order}{Characters of names of Ic to be plotted in a desired \code{order}. Default is NULL.}

\item{main}{A character vector. The title of the plot. Default is NULL.}

\item{ylab}{titles y axes, as in plot.}

\item{fun}{A character choose between ('matplot', 'boxplot'), indicating plot type.}

\item{which2point}{A character (or integer) which state's values were used to set up the three horizontal lines.
by default is NULL,  indicating the values of all states will be used.}
}
\value{
Return a plot of the observed Ic (red) and simulated Ic (grey) scores per states.
}
\description{
Generate a line (or box) plot of Ic score and simulated Ic scores,
with three horizontal lines: the min,  max and 2*(max-min) value of the state of interests, or all values.
}
\examples{
sim = matrix(sample(1:10, 9), 3, 3)
row.names(sim) = paste0('state', 1:3)
Ic = c('state1' = 3.4, 'state2' = 5.6, 'state3' = 2)
plot_Ic_Simulation(Ic, sim)
}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}; Xinan H Yang \email{xyang2@uchicago.edu}
}
