% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OBOSet-class.R
\name{OBOSet}
\alias{OBOSet}
\alias{OBOSet-class}
\title{OBOSet class}
\usage{
OBOSet(elementset, element, set, metadata)
}
\arguments{
\item{elementset}{A tibble with element set information.}

\item{element}{A tibble with element information.}

\item{set}{A tibble with set information.}

\item{metadata}{A tibble with key-value pairs describing OBO file
format header data}
}
\value{
An S4 \code{OBOOSet} object. OBO sets conform to the 'obo'
    file format, with OBO 'Term' entries corresponding to
    elements. Parent / child relationships (e.g., 'is_a') are
    summarized as 'parents', 'ancestors', and 'children' character
    list columns of 'set'.
}
\description{
A class representing the 'OBO' file format as a BiocSet.
}
\examples{
OBOSet()
oboFile <- system.file(package = "BiocSet", "extdata", "sample_go.obo")
import(oboFile)
}
