% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{TCGABRCAobj}
\alias{TCGABRCAobj}
\title{TCGABRCAobj: Example dataset (TCGA-BRCA subset)}
\format{
A list with:
\describe{
\item{\code{se_obj}}{A \code{SummarizedExperiment} containing the integer raw-count matrix
(top 5,000 variable genes), \code{rowData} with \code{probe}, \code{SYMBOL}, \code{ENTREZID},
\code{Length}, and \code{colData} with \code{PatientID}, \code{ER}, \code{PR}, \code{HER2}.}
\item{\code{data_input}}{Example \code{Mapping()} output created from \code{se_obj}.}
\item{\code{res}}{Example \code{BS_Multi()} results (e.g., run in \emph{AUTO} mode).}
}
}
\source{
The Cancer Genome Atlas (TCGA) BRCA via GDC; counts summarized with \code{recount3};
clinical data retrieved with \code{TCGAbiolinks}.
}
\usage{
data("TCGABRCAobj")
}
\description{
Example object derived from TCGA-BRCA. Includes a subset of normalized metadata
\itemize{
\item raw counts (as a SummarizedExperiment), and example outputs from \code{Mapping()}
and \code{BS_Multi()} to facilitate runnable examples.
}
}
\examples{
library(BreastSubtypeR)
data("TCGABRCAobj")
names(TCGABRCAobj)
# str(TCGABRCAobj$se_obj); head(colData(TCGABRCAobj$se_obj))
}
\references{
The Cancer Genome Atlas Network.
Comprehensive molecular portraits of human breast tumors.
\emph{Nature}. 2012;490(7418):61–70. https://doi.org/10.1038/nature11412

Colaprico A, Silva TC, Olsen C, Garofano L, Cava C, Garolini D, et al.
TCGAbiolinks: an R/Bioconductor package for integrative analysis of TCGA data.
\emph{Nucleic Acids Res}. 2016;44(8):e71. https://doi.org/10.1093/nar/gkv1507

Collado-Torres L, Nellore A, Kammers K, Ellis SE, Taub MA, Hansen KD, et al.
Reproducible RNA-seq analysis using recount2.
\emph{Nat Biotechnol}. 2017;35(4):319–321. https://doi.org/10.1038/nbt.3838
}
\keyword{datasets}
