% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFrameMatrix.R
\docType{class}
\name{BumpyDataFrameMatrix}
\alias{BumpyDataFrameMatrix}
\alias{BumpyDataFrameMatrix-class}
\alias{show,BumpyDataFrameMatrix-method}
\alias{commonColnames,BumpyDataFrameMatrix-method}
\alias{commonColnames<-,BumpyDataFrameMatrix-method}
\alias{[,BumpyDataFrameMatrix,ANY-method}
\alias{[,BumpyDataFrameMatrix,ANY,ANY,ANY-method}
\alias{[,BumpyDataFrameMatrix,BumpyMatrix-method}
\alias{[,BumpyDataFrameMatrix,BumpyMatrix,ANY,ANY-method}
\alias{[<-,BumpyDataFrameMatrix,ANY,ANY,BumpyMatrix-method}
\title{The BumpyDataFrameMatrix class}
\description{
The BumpyDataFrameMatrix provides a two-dimensional object where each entry is a \linkS4class{DataFrame}.
This is useful for storing data that has a variable number of observations per sample/feature combination,
e.g., for inclusion as another assay in a SummarizedExperiment object.
}
\details{
In the following code snippets, \code{x} is a BumpyDataFrameMatrix.

\code{commonColnames(x)} will return a character vector with the names of the available commonColnames.
This can be modified with \code{commonColnames(x) <- value}.

\code{x[i, j, k, ..., .dropk=drop, drop=TRUE]} will subset the BumpyDataFrameMatrix:
\itemize{
\item If \code{k} is not specified, this will either produce another BumpyDataFrameMatrix corresponding to the specified submatrix,
or a \linkS4class{CompressedSplitDataFrameList} containing the entries of interest if \code{drop=TRUE}.
\item If \code{k} is specified, it should contain the names or indices of the columns of the underlying DataFrame to retain.
For multiple fields or with \code{.dropk=FALSE}, a new BumpyDataFrameMatrix is returned with the specified columns in the DataFrame.
\item If \code{k} only specifies a single column and \code{.dropk=TRUE},
a BumpyMatrix (or \linkS4class{CompressedList}, if \code{drop=TRUE}) corresponding to the type of the field is returned.
}

\code{x[i, j, k, ...] <- value} will modify \code{x} by replacing the specified values with those in the BumpyMatrix \code{value} of the same dimensions.
If \code{k} is not specified, \code{value} should be a BumpyDataFrameMatrix with the same fields as \code{x}.
If \code{k} is specified, \code{value} should be a BumpyDataFrameMatrix with the specified fields.
If \code{k} contains a single field, \code{value} can also be a BumpyAtomicMatrix containing the values to use in that field.

All methods described for the \linkS4class{BumpyMatrix} parent class are available.
}
\examples{
library(S4Vectors)
df <- DataFrame(x=runif(100), y=runif(100))
f <- factor(sample(letters[1:20], nrow(df), replace=TRUE), letters[1:20])
out <- split(df, f)

# Making our BumpyDataFrameMatrix.
mat <- BumpyMatrix(out, c(5, 4))
mat[,1]
mat[1,]

# Subsetting capabilities.
xmat <- mat[,,"x"]
ymat <- mat[,,"y"]
filtered <- mat[xmat > 0.5 & ymat > 0.5]
filtered[,1]

# Subset replacement works as expected.
mat2 <- mat
mat2[,,"x"] <- mat2[,,"x"] * 2
mat2[,1]

}
\author{
Aaron Lun
}
