% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calcSupport}
\alias{calcSupport}
\title{Calculate support of CAGE data.}
\usage{
calcSupport(
  object,
  inputAssay = "counts",
  outputColumn = "support",
  unexpressed = 0
)
}
\arguments{
\item{object}{RangedSummarizedExperiment: CAGE data quantified at CTSS,
cluster or gene-level.}

\item{inputAssay}{character: Name of assay holding input expression values.}

\item{outputColumn}{character: Name of column in rowRanges to hold support
values.}

\item{unexpressed}{numeric: Support will be calculated based on features
larger than this cutoff.}
}
\value{
object with support added as a column in rowRanges.
}
\description{
Calculate the number of samples expression a feature above a certain level.
This number is refered to as the 'support'.
}
\examples{
data(exampleUnidirectional)

# Count samples with at at least a single tags
exampleUnidirectional <- calcSupport(exampleUnidirectional,
                                     inputAssay='counts',
                                     unexpressed=0)

# Count number of samples with more than 1 TPM and save as a new column.
exampleUnidirectional <- calcTPM(exampleUnidirectional,
                                 totalTags = 'totalTags')
exampleUnidirectional <- calcSupport(exampleUnidirectional,
                                     inputAssay='TPM',
                                     unexpressed=1,
                                     outputColumn='TPMsupport')
}
\seealso{
Other Calculation functions: 
\code{\link{calcBidirectionality}()},
\code{\link{calcComposition}()},
\code{\link{calcPooled}()},
\code{\link{calcShape}()},
\code{\link{calcTPM}()},
\code{\link{calcTotalTags}()},
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetByComposition}()},
\code{\link{subsetBySupport}()}
}
\concept{Calculation functions}
