% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhancers.R
\name{clusterBidirectionally}
\alias{clusterBidirectionally}
\alias{clusterBidirectionally,GRanges-method}
\alias{clusterBidirectionally,GPos-method}
\alias{clusterBidirectionally,RangedSummarizedExperiment-method}
\title{Bidirectional clustering of pooled CTSSs.}
\usage{
clusterBidirectionally(object, ...)

\S4method{clusterBidirectionally}{GRanges}(
  object,
  window = 201,
  balanceThreshold = 0.95,
  balanceFun = balanceBC
)

\S4method{clusterBidirectionally}{GPos}(object, ...)

\S4method{clusterBidirectionally}{RangedSummarizedExperiment}(object, ...)
}
\arguments{
\item{object}{GenomicRanges or RangedSummarizedExperiment: Pooled CTSSs
stored in the score column.}

\item{...}{additional arguments passed to methods.}

\item{window}{integer: Width of sliding window used for calculating window
sums.}

\item{balanceThreshold}{numeric: Minimum value of the BC to use for
slice-reduce, a value of 1 corresponds to perfectly balanced sites.}

\item{balanceFun}{function: Advanced users may supply their own function for
calculating the balance score instead of the the default balanceBC. See
details for instructions.}
}
\value{
GRanges with bidirectional sites: Minimum width is 1 + 2*window, TPM
  sum (on both strands) in the score column, maximal bidirectional site in
  the thick column and maximum balance in the balance column.
}
\description{
Finds sites with (balanced and divergent) bidirectional transcription using
sliding windows of summed coverage: The Bhattacharyya coefficient (BC) is
used to quantify depature from a perfectly balanced site, and a slice-reduce
is used to identify sites.
}
\examples{
\dontrun{
data(exampleCTSSs)

# Calculate pooledTPM, using supplied number of total tags
exampleCTSSs <- calcTPM(exampleCTSSs,
                        inputAssay='counts',
                        outputAssay='TPM',
                        totalTags='totalTags')
exampleCTSSs <- calcPooled(exampleCTSSs, inputAssay='TPM')

# Cluster using defaults: balance-treshold of 199 and window of 199 bp:
clusterBidirectionally(exampleCTSSs)

# Use custom thresholds:
clusterBidirectionally(exampleCTSSs, balanceThreshold=0.99, window=101)
}
}
\seealso{
Other Clustering functions: 
\code{\link{clusterUnidirectionally}()},
\code{\link{trimToPeak}()},
\code{\link{trimToPercentiles}()},
\code{\link{tuneTagClustering}()}
}
\concept{Clustering functions}
