% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify.R
\name{quantifyClusters}
\alias{quantifyClusters}
\title{Quantify expression of clusters (TSSs or enhancers) by summing CTSSs within
clusters.}
\usage{
quantifyClusters(object, clusters, inputAssay = "counts", sparse = FALSE)
}
\arguments{
\item{object}{RangedSummarizedExperiment: CTSSs.}

\item{clusters}{GRanges: Clusters to be quantified.}

\item{inputAssay}{character: Name of assay holding expression values to be
quantified (usually counts).}

\item{sparse}{logical: If the input is a sparse matrix, TRUE will keep the
output matrix sparse while FALSE will coerce it into a normal matrix.}
}
\value{
RangedSummarizedExperiment with row corresponding to clusters.
  seqinfo and colData is copied over from object.
}
\description{
Quantify expression of clusters (TSSs or enhancers) by summing CTSSs within
clusters.
}
\examples{
# CTSSs stored in a RangedSummarizedExperiment:
data(exampleCTSS)

# Clusters to be quantified as a GRanges:
data(exampleUnidirectional)
clusters <- rowRanges(exampleUnidirectional)

# Quantify clusters:
quantifyClusters(exampleCTSSs, clusters)

# For exceptionally large datasets,
# the resulting count matrix can be left sparse:
quantifyClusters(exampleCTSSs, rowRanges(exampleUnidirectional), sparse=TRUE)
}
\seealso{
Other Quantification functions: 
\code{\link{quantifyCTSSs2}()},
\code{\link{quantifyCTSSs}()},
\code{\link{quantifyGenes}()}
}
\concept{Quantification functions}
