% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetBy.R
\name{subsetBySupport}
\alias{subsetBySupport}
\title{Subset by support across samples}
\usage{
subsetBySupport(
  object,
  inputAssay = "counts",
  outputColumn = "support",
  unexpressed = 0,
  minSamples = 1
)
}
\arguments{
\item{object}{RangedSummarizedExperiment: CAGE data quantified at CTSS,
cluster or gene-level.}

\item{inputAssay}{character: Name of assay holding input expression values.}

\item{outputColumn}{character: Name of column in rowRanges to hold support
values.}

\item{unexpressed}{numeric: Support will be calculated based on features
larger than this cutoff.}

\item{minSamples}{numeric: Only features with support in more than this
number of samples will be kept.}
}
\value{
RangedSummarizedExperiment with support added as a column in
  rowRanges and features with less support than minSamples removed.
}
\description{
A convienient wrapper around calcSupport and subset.
}
\examples{
data(exampleBidirectional)

# Keep clusters with at least one tag in two samples
subsetBySupport(exampleBidirectional)

# Keep clusters with at least two tags in four samples
subsetBySupport(exampleBidirectional, unexpressed=1, minSamples=2)
}
\seealso{
Other Subsetting functions: 
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetByComposition}()}

Other Calculation functions: 
\code{\link{calcBidirectionality}()},
\code{\link{calcComposition}()},
\code{\link{calcPooled}()},
\code{\link{calcShape}()},
\code{\link{calcSupport}()},
\code{\link{calcTPM}()},
\code{\link{calcTotalTags}()},
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetByComposition}()}
}
\concept{Calculation functions}
\concept{Subsetting functions}
