% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{trackCTSS}
\alias{trackCTSS}
\alias{trackCTSS,GRanges-method}
\alias{trackCTSS,RangedSummarizedExperiment-method}
\alias{trackCTSS,GPos-method}
\title{Create Genome Browser track of CTSSs.}
\usage{
trackCTSS(object, ...)

\S4method{trackCTSS}{GRanges}(object, plusColor = "cornflowerblue", minusColor = "tomato", ...)

\S4method{trackCTSS}{RangedSummarizedExperiment}(object, ...)

\S4method{trackCTSS}{GPos}(object, ...)
}
\arguments{
\item{object}{GenomicRanges or RangedSummarizedExperiment: Ranges with CTSSs
in the score column.}

\item{...}{additional arguments passed on to DataTrack.}

\item{plusColor}{character: Color for plus-strand coverage.}

\item{minusColor}{character: Color for minus-strand coverage.}
}
\value{
DataTrack-object.
}
\description{
Create a Gviz-track of CTSSs, where Plus/minus strand signal is shown
positive/negative. This representation makes it easy to identify
bidirectional peaks.
}
\examples{
library(Gviz)
data(exampleCTSSs)
data(exampleUnidirectional)
data(exampleBidirectional)

# Example uni- and bidirectional clusters
TC <- rowRanges(subset(exampleUnidirectional, width>=100)[3,])
BC <- rowRanges(exampleBidirectional[3,])

# Create pooled track
subsetOfCTSSs <- subsetByOverlaps(rowRanges(exampleCTSSs), c(BC, TC, ignore.mcols=TRUE))
pooledTrack <- trackCTSS(subsetOfCTSSs)

# Plot
plotTracks(pooledTrack, from=start(TC)-100, to=end(TC)+100,
           chromosome=seqnames(TC), name='TC')
plotTracks(pooledTrack, from=start(BC)-100, to=end(BC)+100,
           chromosome=seqnames(BC), name='BC')

# See vignette for examples on how to combine multiple Gviz tracks
}
\seealso{
Other Genome Browser functions: 
\code{\link{trackBalance}()},
\code{\link{trackClusters}()},
\code{\link{trackLinks}()}
}
\concept{Genome Browser functions}
