% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionProfilingMethods.R
\name{getExpressionProfiles}
\alias{getExpressionProfiles}
\alias{getExpressionProfiles,CAGEexp-method}
\alias{getExpressionProfiles,matrix-method}
\title{CAGE data based expression clustering}
\usage{
getExpressionProfiles(
  object,
  what = c("CTSS", "consensusClusters"),
  tpmThreshold = 5,
  nrPassThreshold = 1,
  method = c("som", "kmeans"),
  xDim = 5,
  yDim = 5
)

\S4method{getExpressionProfiles}{CAGEexp}(
  object,
  what = c("CTSS", "consensusClusters"),
  tpmThreshold = 5,
  nrPassThreshold = 1,
  method = c("som", "kmeans"),
  xDim = 5,
  yDim = 5
)

\S4method{getExpressionProfiles}{matrix}(
  object,
  what = c("CTSS", "consensusClusters"),
  tpmThreshold = 5,
  nrPassThreshold = 1,
  method = c("som", "kmeans"),
  xDim = 5,
  yDim = 5
)
}
\arguments{
\item{object}{A \code{\link{CAGEexp}} object}

\item{what}{At which level the expression clustering is done (\code{CTSS} or
\code{consensusClusters})}

\item{tpmThreshold, nrPassThreshold}{Ignore clusters when their normalized
CAGE signal is lower than \code{tpmThreshold} in at least \code{nrPassThreshold}
experiments.}

\item{method}{Method to be used for expression clustering.  \code{som} uses the
self-organizing map (SOM) algorithm of Toronen and coll., FEBS Letters (1999)
\code{\link[som:som]{som::som}}] function from \emph{som} package.  \code{kmeans} uses the K-means
algorithm implemented in the \code{\link[stats:kmeans]{stats::kmeans}}] function.}

\item{xDim, yDim}{With \code{method = "kmeans"}, \code{xDim} specifies number of clusters
that will be returned by K-means algorithm and \code{yDim} is ignored.  With
\code{method = "som"}, \code{xDim} specifies the the first and \code{yDim} the second
dimension of the self-organizing map, which results in total $xDim x yDim$
clusters returned by SOM.}
}
\value{
Returns a modified \code{CAGEexp} object.  If \code{what = "CTSS"} the
objects's metadata elements \code{CTSSexpressionClusteringMethod} and
\code{CTSSexpressionClasses} will be set accordingly, and if
\code{what = "consensusClusters"} the elements \code{consensusClustersExpressionClusteringMethod}
and \code{consensusClustersExpressionClasses} will be set.  Labels of expression
classes (clusters) can be retrieved using \code{\link{expressionClasses}} function.
}
\description{
Clusters CAGE expression across multiple experiments, both at
level of individual TSSs or entire clusters of TSSs.
}
\details{
Expression clustering can be done at level of individual CTSSs, in
which case the feature vector used as input for clustering algorithm contains
log-transformed and scaled (divided by standard deviation) normalized CAGE
signal at individual TSS across multiple experiments.  Only TSSs with
normalized CAGE signal \verb{>= tpmThreshold} in at least \code{nrPassThreshold} CAGE
experiments are used for expression clustering.  However, CTSSs along the
genome can be spatially clustered into tag clusters for each experiment
separately using a CTSS clustering function, and then aggregated across
experiments into consensus clusters using \code{\link{aggregateTagClusters}} function.
Once the consensus clusters have been created, expression clustering at the
level of these wider genomic regions (representing entire promoters rather
than individual TSSs) can be performed.  In that case the feature vector
used as input for clustering algorithm contains normalized CAGE signal
within entire consensus cluster across multiple experiments, and threshold
values in \code{tpmThreshold} and \code{nrPassThreshold} are applied to entire
consensus clusters.
}
\examples{
getExpressionProfiles( exampleCAGEexp, "CTSS"
                     , tpmThreshold = 50, nrPassThreshold = 1
                     , method = "som", xDim = 3, yDim = 3)
                     
getExpressionProfiles( exampleCAGEexp, "CTSS"
                     , tpmThreshold = 50, nrPassThreshold = 1
                     , method = "kmeans", xDim = 3)

getExpressionProfiles(exampleCAGEexp, "consensusClusters")

}
\references{
Toronen \emph{et al.} (1999) Analysis of gene expression data using
self-organizing maps, \emph{FEBS Letters} \emph{451}:142-146.
}
\seealso{
Other CAGEr expression clustering functions: 
\code{\link{expressionClasses}()},
\code{\link{plotExpressionProfiles}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr expression clustering functions}
