% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantileWidthMethods.R
\name{quantilePositions}
\alias{quantilePositions}
\alias{quantilePositions,CAGEexp-method}
\title{Determine CTSS quantile positions within clusters}
\usage{
quantilePositions(
  object,
  clusters = c("tagClusters", "consensusClusters"),
  qLow = 0.1,
  qUp = 0.9,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{quantilePositions}{CAGEexp}(
  object,
  clusters = c("tagClusters", "consensusClusters"),
  qLow = 0.1,
  qUp = 0.9,
  useMulticore = FALSE,
  nrCores = NULL
)
}
\arguments{
\item{object}{A CAGEexp object.}

\item{clusters}{Either \code{tagClusters} or \code{consensusClusters}.}

\item{qLow, qUp}{Which \dQuote{lower} or \dQuote{upper} quantiles should be
calculated. Numeric vector of values in range \verb{[0,1]}.}

\item{useMulticore}{Logical, should multicore be used.  \code{useMulticore = TRUE}
has only effect on Unix-like platforms.}

\item{nrCores}{Number of cores to use when \code{useMulticore = TRUE}.  Default
value \code{NULL} uses all detected cores.}
}
\value{
Returns the objects, in which the positions of the quantiles are
defined relatively to the start point of their cluster, for more efficient
\code{Rle} compression.  The quantile data for \emph{tag clusters} are stored in the
\code{TagClusters} objects directly.  The quantile data for \verb{consensus clusters}
are stored in \code{\link{integer}} matrices named \dQuote{q_\emph{x}}, where \emph{x}
represents the quantile (for instance, \code{q_0.1}), and these matrices are
\emph{assays} of the \code{consensusClusters} \code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::RangedSummarizedExperiment}}.
}
\description{
Calculates the positions of \dQuote{upper} and \dQuote{lower}
quantiles of CAGE signal along \emph{tag clusters} or \emph{consensus clusters} in each
sample of a \code{\link{CAGEexp}} object.
}
\details{
From the 5' end the position, the position of a quantile \emph{q} is
determined as the first base in which of the cumulative expression is higher
or equal to \emph{q\%} of the total CAGE signal of that cluster.  Promoter
\emph{interquantile width} is defined as the distance (in base pairs) between a
\dQuote{lower} and an \dQuote{upper} quantile position.
}
\examples{

quantilePositions(exampleCAGEexp, "tagClusters",       qLow = c(0.1, 0.2), qUp = c(0.8, 0.9))
tagClustersGR(exampleCAGEexp)
quantilePositions(exampleCAGEexp, "consensusClusters", qLow = c(0.1, 0.2), qUp = c(0.8, 0.9))

}
\seealso{
Other CAGEr object modifiers: 
\code{\link{CTSStoGenes}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{annotateCTSS}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{getCTSS}()},
\code{\link{normalizeTagCount}()},
\code{\link{paraclu}()},
\code{\link{quickEnhancers}()},
\code{\link{resetCAGEexp}()},
\code{\link{summariseChrExpr}()}

Other CAGEr clusters functions: 
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{consensusClustersDESeq2}()},
\code{\link{consensusClustersGR}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{paraclu}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr clusters functions}
\concept{CAGEr object modifiers}
