% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cemitool.R
\name{cemitool}
\alias{cemitool}
\title{Full gene co-expression analysis}
\usage{
cemitool(
  expr,
  annot,
  gmt,
  interactions,
  filter = TRUE,
  filter_pval = 0.1,
  apply_vst = FALSE,
  n_genes,
  eps = 0.1,
  cor_method = c("pearson", "spearman"),
  cor_function = "cor",
  network_type = "unsigned",
  tom_type = "signed",
  set_beta = NULL,
  force_beta = FALSE,
  sample_name_column = "SampleName",
  class_column = "Class",
  merge_similar = TRUE,
  rank_method = "mean",
  ora_pval = 0.05,
  gsea_scale = TRUE,
  gsea_min_size = 15,
  gsea_max_size = 1000,
  min_ngen = 30,
  diss_thresh = 0.8,
  plot = TRUE,
  plot_diagnostics = TRUE,
  order_by_class = TRUE,
  center_func = "mean",
  directed = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{expr}{Gene expression \code{data.frame}.}

\item{annot}{Sample annotation \code{data.frame}.}

\item{gmt}{A data.frame containing two columns, one with pathways and one with genes}

\item{interactions}{A data.frame containing two columns with gene names.}

\item{filter}{Logical. If TRUE, will filter expression data.}

\item{filter_pval}{P-value threshold for filtering. Default \code{0.1}.}

\item{apply_vst}{Logical. If TRUE, will apply Variance Stabilizing Transform before filtering genes.
Currently ignored if parameter \code{filter} is FALSE.}

\item{n_genes}{Number of genes left after filtering.}

\item{eps}{A value for accepted R-squared interval between subsequent beta values. Default is 0.1.}

\item{cor_method}{A character string indicating which correlation coefficient is
to be computed. One of \code{"pearson"} or \code{"spearman"}.
Default is \code{"pearson"}.}

\item{cor_function}{A character string indicating the correlation function to be used. Supported functions are
currently 'cor' and 'bicor'. Default is \code{"cor"}}

\item{network_type}{A character string indicating if network type should be computed
as \code{"signed"} or \code{"unsigned"}. Default is \code{"unsigned"}}

\item{tom_type}{A character string indicating if the TOM type should be computed
as \code{"signed"} or \code{"unsigned"}. Default is \code{"signed"}}

\item{set_beta}{A value to override the automatically selected beta value. Default is NULL.}

\item{force_beta}{Whether or not to automatically force a beta value based on number of samples. Default is FALSE.}

\item{sample_name_column}{A character string indicating the sample column
name of the annotation table.}

\item{class_column}{A character string indicating the class column name of the
annotation table.}

\item{merge_similar}{Logical. If \code{TRUE}, merge similar modules.}

\item{rank_method}{Character string indicating how to rank genes. Either "mean"
(the default) or "median".}

\item{ora_pval}{P-value for overrepresentation analysis. Default \code{0.05}.}

\item{gsea_scale}{If TRUE, apply z-score transformation for GSEA analysis. Default is \code{TRUE}}

\item{gsea_min_size}{Minimum size of gene sets for GSEA analysis. Default is \code{15}}

\item{gsea_max_size}{Maximum size of gene sets for GSEA analysis. Default is \code{1000}}

\item{min_ngen}{Minimal number of genes per submodule. Default \code{30}.}

\item{diss_thresh}{Module merging correlation threshold for eigengene similarity.
Default \code{0.8}.}

\item{plot}{Logical. If \code{TRUE}, plots all figures.}

\item{plot_diagnostics}{Logical. If \code{TRUE}, creates diagnostic plots. Overwritten if plot=FALSE.}

\item{order_by_class}{Logical. If \code{TRUE}, samples in profile plot are ordered by the groups
defined by the class_column slot in the sample annotation file. Ignored if there is no
sample_annotation file. Default \code{TRUE}.}

\item{center_func}{Character string indicating the centrality measure to show in
the plot. Either 'mean' (the default) or 'median'.}

\item{directed}{Logical. If \code{TRUE}, the igraph objects in interactions slot will be directed.}

\item{verbose}{Logical. If \code{TRUE}, reports analysis steps.}
}
\value{
Object of class \code{CEMiTool}
}
\description{
Defines co-expression modules and runs several different analyses.
}
\examples{
# Get example expression data
data(expr0)
# Run CEMiTool analyses
cem <- cemitool(expr=expr0)
# Run CEMiTool applying Variance Stabilizing Transformation to data
cem <- cemitool(expr=expr0, apply_vst=TRUE)
# Run CEMiTool with additional processing messages
cem <- cemitool(expr=expr0, verbose=TRUE)

\dontrun{
# Run full CEMiTool analysis
## Get example sample annotation data
data(sample_annot)
## Read example pathways file
gmt_fname <- system.file("extdata", "pathways.gmt", package = "CEMiTool")
gmt_in <- read_gmt(gmt_fname)
## Get example interactions file
int_df <- read.delim(system.file("extdata", "interactions.tsv", package = "CEMiTool"))
## Run CEMiTool
cem <- cemitool(expr=expr0, annot=sample_annot, gmt=gmt_in,
    interactions=int_df, verbose=TRUE, plot=TRUE)

# Create report as html file
generate_report(cem, directory = "./Report", output_format="html_document")

# Write analysis results into files
write_files(cem, directory="./Tables", force=TRUE)

# Save all plots
save_plots(cem, "all", directory="./Plots")
}
}
