% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils_CHETAH.R
\name{RenameBelowNode}
\alias{RenameBelowNode}
\title{In the CHETAH classification, replace the name of a Node
and all the names of the final and intermediate types under that Node.}
\usage{
RenameBelowNode(
  input,
  whichnode,
  replacement,
  nodes_exclude = NULL,
  types_exclude = NULL,
  node_only = FALSE,
  return_clas = FALSE
)
}
\arguments{
\item{input}{a SingleCellExperiment on which \code{\link{CHETAHclassifier}} has been run}

\item{whichnode}{the number of the Node}

\item{replacement}{a character vector that replaces the names under the selected Node}

\item{nodes_exclude}{\emph{optional} the names of the types that should  \strong{NOT} be replaced}

\item{types_exclude}{\emph{optional} numbers of the Nodes under the selected Node, that should \strong{NOT} be replaced}

\item{node_only}{only rename the Node itself, without affecting the types under that Node}

\item{return_clas}{Instead of returning the SingleCellExperiment, only return the classification vector}
}
\value{
The SingleCellExperiment with the new classification or if `return_clas = TRUE` the classification vector.
}
\description{
In the CHETAH classification, replace the name of a Node
and all the names of the final and intermediate types under that Node.
}
\examples{
## In the example data replace all T-cell subtypes by "T cell"
data('input_mel')
#' input_mel <- RenameBelowNode(input = input_mel, whichnode = 7, replacement = "T cell")
}
