% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scores.R
\name{FunctionalityScore}
\alias{FunctionalityScore}
\alias{FunctionalityScore.COMPASSResult}
\alias{FunctionalityScore.default}
\title{Compute the Functionality Score for each subject fit in a COMPASS model}
\usage{
FunctionalityScore(x, n, markers = NULL)

\method{FunctionalityScore}{COMPASSResult}(x, n, markers = NULL)

\method{FunctionalityScore}{default}(x, n, markers = NULL)
}
\arguments{
\item{x}{An object of class \code{COMPASSResult}, as returned by
\code{\link{COMPASS}}. Alternatively, a matrix of functionality scores,
used under the assumption that the 'null' category has been dropped.}

\item{n}{The number of markers included in an experiment. It is inferred
from the data when \code{x} is a \code{COMPASSResult}.}

\item{markers}{The set of markers for which to compute a Functionality score. By default uses all markers. Must match names returned by \code{markers()}.}
}
\value{
A numeric vector of functionality scores.
}
\description{
Computes the functionality score for each observation from the gamma matrix
of a COMPASS model fit. The scores are normalized according to the total
number of possible subsets that could be observed (\code{2^M - 1}).
}
\note{
The null category is implicitly dropped when computing the functionality
  score for a \code{COMPASS} result; this is not true for the regular matrix
  method.
}
\examples{
FunctionalityScore(CR)
}
