% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scores.R
\name{PolyfunctionalityScore}
\alias{PolyfunctionalityScore}
\alias{PolyfunctionalityScore.COMPASSResult}
\alias{PolyfunctionalityScore.default}
\title{Compute the Polyfunctionality Score for each subject fit in a COMPASS model}
\usage{
PolyfunctionalityScore(x, degree, n, markers = NULL)

\method{PolyfunctionalityScore}{COMPASSResult}(x, degree, n, markers = NULL)

\method{PolyfunctionalityScore}{default}(x, degree, n, markers = NULL)
}
\arguments{
\item{x}{An object of class \code{COMPASSResult}, as returned by
\code{\link{COMPASS}}. Alternatively, a matrix of functionality scores.}

\item{degree}{A vector of weights. If missing, this is the 'degree of
functionality', that is, the number of markers expressed in a particular
category.}

\item{n}{The total number of markers. This is inferred when \code{x} is a
\code{COMPASSResult}, and is unused in that case.}

\item{markers}{A \code{character} specifying the markers for which to compute the score. Must match names in \code{markers()}.}
}
\value{
A numeric vector of polyfunctionality scores.
}
\description{
Computes the Polyfunctionality score for each observation from the
gamma matrix of a \code{COMPASS} model fit. The scores are normalized to
one.
}
\examples{
PolyfunctionalityScore(CR)
}
