% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Posterior.R
\name{Posterior}
\alias{Posterior}
\alias{PosteriorDiff}
\alias{PosteriorLogDiff}
\alias{PosteriorPs}
\alias{PosteriorPu}
\title{Retrieve Posterior Measures from a COMPASS fit}
\usage{
Posterior(x)

PosteriorDiff(x)

PosteriorLogDiff(x)

PosteriorPs(x)

PosteriorPu(x)
}
\arguments{
\item{x}{An object of class \code{COMPASSResult}.}
}
\description{
These functions can be used to retrieve different posterior measures
from a \code{COMPASS} fit object.
}
\details{
The posterior items retrieved are described as follows::

\describe{
\item{\code{PosteriorPs}:}{The posterior estimate of the proportion of cells in the stimulated sample.}
\item{\code{PosteriorPu:}}{The posterior estimate of the proportio of cells in the unstimulated sample.}
\item{\code{PosteriorDiff}:}{The difference in posterior proportions,
as described above.}
\item{\code{PosteriorLogDiff}:}{The difference in the log posterior proportions,
as described above.}
}
}
\examples{
Posterior(CR)
PosteriorPs(CR)
PosteriorPu(CR)
PosteriorDiff(CR)
PosteriorLogDiff(CR)
}
