% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{translate_marker_names}
\alias{translate_marker_names}
\title{Translate marker names to format use by COMPASS}
\usage{
translate_marker_names(cellpops)
}
\arguments{
\item{cellpops}{\code{character} vector of cell population names.}
}
\value{
\code{character} vector of cell population names used by COMPASS
}
\description{
Translate boolean population names from format exported by common
software tools to a format used by COMPASS.
}
\examples{
#Generate marker names
markers = LETTERS[1:4]
pos = c("+","-")
popnames = apply(expand.grid(pos,pos,pos,pos),1,
              function(x) paste(paste(paste(markers,x,sep=""),
              collapse=""),",Count",sep=""))
popnames = sample(c(popnames,
           paste(paste(markers,sample(c("+","-"),
           length(markers),replace=TRUE),sep=""),
           ",Count",sep="")))
popnames = popnames[select_compass_pops(popnames,LETTERS[1:4])]
#Translate
translate_marker_names(popnames)
}
\seealso{
select_compass_pops
}
