% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_NBE.R
\name{cluster2outlier}
\alias{cluster2outlier}
\title{cluster2outlier}
\usage{
cluster2outlier(data, out.cluster)
}
\arguments{
\item{data}{List. The output of Fluo_inspection().}

\item{out.cluster}{Numeric vector. The cluster number(s) to be turned into outlier clusters.}
}
\value{
A list of corrected fluorescence signal estimates with the selected clusters turned into outlier
  clusters.
}
\description{
It turns one or more selected clusters to outlier clusters, i.e. clusters consisting of outlying corrected
  signals.
}
\examples{
### here we (erroneously) assume that cluster 1 is an outlier and we flag it so below
step3.withoutliers <- cluster2outlier(step3,out.cluster=1)

### the outlier samples can be removed by FluoSelection_byRun()
step3.withoutliers <- FluoSelection_byRun(step3.withoutliers,
                                 other=which(step3.withoutliers$GAPgroups[,1]!=-999))
}
