% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_NBE.R
\name{createFluo}
\alias{createFluo}
\title{createFluo}
\usage{
createFluo(data, dateIndex = c(), from.file = FALSE, separator = "_")
}
\arguments{
\item{data}{Data matrix. The output data matrix of LocationMatrix().}

\item{dateIndex}{a date index to be used for storing the output files. It is either transfered from LocationMatrix() or
it is generated here for the first time (e.g. if image analysis was not run by CONFESS or if the analysis has
been repeated many times).}

\item{from.file}{Logical. If TRUE the data is read from a file whose format should be the same to
the output of LocationMatrix(). Default is FALSE.}

\item{separator}{Character string. It separates the run ID from the Well ID in the image filenames
(the <<separator1>> of readFiles()). It is also used here to enable the user perform the analysis
independently of the previous step (cell recognition via imaging). Default is "_".}
}
\value{
A list of reformed data to be used in subsequent analysis:
  index: The sample indices.
  RGexprs: the foreground (columns 1 and 3) and background (columns 2 and 4) signals of each channel that
    have been estimated by spotEstimator() and filtered in LocationMatrix().
  samples: the sample IDs.
  batch: a matrix of the run IDs. The first column contains the original run IDs. The second column is the converted
    original IDs into numeric values (to be used in the statistical modeling step of Fluo_adjustment()).
  size: the estimated cell size.
  image.type: the image type IDs as defined in readFiles(). The parameter is kept in ordeer to enable the user to
    use this function independently of the image analysis step.
  dateIndex: a date index to be used for storing the output files. It is either transfered from LocationMatrix() or
    it is generated here for the first time (e.g. if image analysis was not run by CONFESS or if the analysis has
    been repeated many times).
}
\description{
The data format creator function for the signal normalization step.
}
\examples{
step1 <- createFluo(from.file=system.file("extdata", "Results_of_image_analysis.txt",
package = "CONFESS"),separator="_")
}
