% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{LoggingFunctions}
\alias{LoggingFunctions}
\alias{setLoggingLevel}
\alias{setLoggingFile}
\alias{logThis}
\title{Logging in the \code{COTAN} package}
\usage{
setLoggingLevel(newLevel = 1L)

setLoggingFile(logFileName)

logThis(msg, logLevel = 2L, appendLF = TRUE)
}
\arguments{
\item{newLevel}{the new default logging level. It defaults to 1}

\item{logFileName}{the log file.}

\item{msg}{the message to print}

\item{logLevel}{the logging level of the current message. It defaults to 2}

\item{appendLF}{whether to add a new-line character at the end of the message}
}
\value{
\code{setLoggingLevel()} returns the old logging level or default level
if not set yet.

\code{logThis()} returns TRUE if the message has been printed on the
terminal
}
\description{
Logging is currently supported for all \code{COTAN} functions. It is
possible to see the output on the terminal and/or on a log file. The level
of output on terminal is controlled by the  \code{COTAN.LogLevel} option while
the logging on file is always at its maximum verbosity
}
\details{
\code{setLoggingLevel()} sets the \code{COTAN} logging level. It set the
\code{COTAN.LogLevel} options to one of the following values:
\itemize{
\item 0 - Always on log messages
\item 1 - Major log messages
\item 2 - Minor log messages
\item 3 - All log messages
}

\code{setLoggingFile()} sets the log file for all \code{COTAN} output logs. By
default no logging happens on a file (only on the console). Using this
function \code{COTAN} will use the indicated file to dump the logs produced by
all \code{\link[=logThis]{logThis()}} commands, independently from the log level. It stores the
\code{connection} created by the call to \code{\link[=bzfile]{bzfile()}} in the option:
\code{COTAN.LogFile}

\code{logThis()} prints the given message string if the current log level
is greater or equal to the given log level (it always prints its message on
file if active). It uses \code{\link[=message]{message()}} to actually print the messages on the
\code{\link[=stderr]{stderr()}} connection, so it is subject to \code{\link[=suppressMessages]{suppressMessages()}}
}
\examples{
setLoggingLevel(3) # for debugging purposes only

logFile <- file.path(".", "COTAN_Test1.log")
setLoggingFile(logFile)
logThis("Some log message")
setLoggingFile("") # closes the log file
file.remove(logFile)

logThis("LogLevel 0 messages will always show, ",
        logLevel = 0, appendLF = FALSE)
suppressMessages(logThis("unless all messages are suppressed",
                         logLevel = 0))

}
