% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_testing.R
\name{bfCorrectDF}
\alias{bfCorrectDF}
\title{Perform multiple testing correction and filtering with Bonferroni}
\usage{
bfCorrectDF(
  df,
  nTests = nrow(df),
  pvalThr = 0.05,
  colStr = "pval",
  newColStr = "pvalAdj"
)
}
\arguments{
\item{df}{A dataframe with a column of p-values.}

\item{nTests}{Number of tests. Default to the number of rows in the data
frame.}

\item{pvalThr}{p-value threshold.}

\item{colStr}{Name of the column of p-values.}

\item{newColStr}{Name of the column of adjusted p-values that will be
created.}
}
\value{
The data frame with Benjamini-Yekutieli-corrected p-values.
}
\description{
This function performs the Bonferroni correction for multiple
testing in a dataframe column of p-values and filters the data-frame
based on p-values.
}
\keyword{internal}
