% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBgSubVal.R
\name{getBgSubVal}
\alias{getBgSubVal}
\title{Perform quantification and normalization of count data}
\usage{
getBgSubVal(
  analysisInfo,
  sampleIndex,
  normalizeReadDepth = TRUE,
  normalizeLength = FALSE,
  backgroundSubtract = TRUE,
  countMode = "Union",
  ignore.strand = TRUE,
  inter.feature = FALSE
)
}
\arguments{
\item{analysisInfo}{A 
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}} 
object with regions and sample information from within 
\code{\link{getRegionCounts}}.}

\item{sampleIndex}{Index of the sample to process.}

\item{normalizeReadDepth}{Logical indicating if count data should be 
normalized for library sequencing depth. When TRUE (default), counts will 
be normalized for sequencing depth for each library. When FALSE, no such 
normalization will be performed and raw counts will be used. (default: TRUE)}

\item{normalizeLength}{Logical indicating if count data should be 
normalized to the length of the regions. When TRUE, count data will be 
normalized for the length of the region being analyzed. 
When FALSE (default), no such normalization will be performed. (default: FALSE)}

\item{backgroundSubtract}{Logical indicating if background correction 
should be performed.
When TRUE (default), background subtraction will be performed after 
length and depth normalization if applicable. When FALSE, no background 
subtraction will be performed. (default: TRUE)}

\item{countMode}{Count method passed on to 
summarizeOverlaps from GenomicAlignments package.
(\code{"Union"}, \code{"IntersectionNotEmpty"}, \code{"IntersectionStrict"} 
or \code{"user supplied function"}). (default: "Union")}

\item{ignore.strand}{A logical indicating if strand should be considered 
when matching. (default: TRUE)
Passed on to summarizeOverlaps from GenomicAlignments package.}

\item{inter.feature}{A logical indicating if the `r countMode` should be 
aware of overlapping features. When TRUE, reads mapping to multiple 
features are dropped (i.e., not counted). When FALSE (default), these reads
are retained and a count is assigned to each feature they map to. Passed on 
to summarizeOverlaps from GenomicAlignments package. (default: FALSE)}
}
\value{
A vector containing the counts for all the regions.
}
\description{
This function quantifies each each region for a sample and performs
background correction and normalization as instructed. 
Returns a vector of count information for the input regions.
}
\examples{
regionBed <- read.table(system.file("extdata", "chr19_regions.bed", 
package="CSSQ",mustWork = TRUE))
sampleInfo <- read.table(system.file("extdata", "sample_info.txt", 
package="CSSQ",mustWork = TRUE),sep="\\t",header=TRUE)
sampleInfo[,3] <- sapply(sampleInfo[,3], 
function(x) system.file("extdata", x, package="CSSQ"))
sampleInfo[,5] <- sapply(sampleInfo[,5], 
function(x) system.file("extdata", x, package="CSSQ"))
regionRange <- GRanges(seqnames=regionBed$V1,
ranges=IRanges(start=regionBed$V2,end=regionBed$V3))
analysisInfo <- SummarizedExperiment(rowRanges=regionRange,
colData=sampleInfo)
NormbgSubCounts <- data.frame(sapply(c(1:nrow(colData(analysisInfo))),
function(x) getBgSubVal(analysisInfo,sampleIndex = x,backgroundSubtract=TRUE,
normalizeReadDepth=TRUE,normalizeLength=FALSE,countMode="Union", 
ignore.strand=TRUE,inter.feature=FALSE)))
NormbgSubCounts
}
\seealso{
\code{\link{getRegionCounts}} which calls this function
}
