# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Tolerance level between 3 pairwise correlations implemented in C/C++
#' 
#' @description Calculates the local tolerance for every trio of genes.
#' 
#' @param a Correlation value between the genes A and B.
#' @param b Correlation value between the genes B and C.
#' @param c Correlation value between the genes A and C.
#' @param tolType Calculation type for tolerance (1 for mean, 2 for min and 3 for max).
#'
#' @return Returns the value of tolerance.
#' 
#' @seealso See vignette for more details about the pairwise correlations.
#' 
#' @examples
#' tolerance(0.5, -0.65, 0.23, tolType = 1)
#' tolerance(0.5, -0.65, 0.23, tolType = 2)
#' tolerance(0.5, -0.65, 0.23, tolType = 3)
#' 
#' @rawNamespace useDynLib(CeTF)
#' @import Rcpp
#' @export
tolerance <- function(a, b, c, tolType) {
    .Call('_CeTF_tolerance', PACKAGE = 'CeTF', a, b, c, tolType)
}

#' @title A helper to calculate PCIT implemented in C/C++
#' 
#' @description Calculates the correlation matrix using PCIT algorithm
#'
#' @param cor A correlation matrix.
#' @param tolType Type of tolerance (default: 'mean') given the 3 pairwise correlations 
#' (see \code{\link{tolerance}}.
#' 
#' @return Correlation matrix resulted from PCIT algorithm.
#' 
#' @seealso (see \code{\link{PCIT}})
#' 
#' @examples
#' library(Matrix)
#' 
#' # loading a simulated normalized data
#' data('simNorm')
#' 
#' # calculating the correlation matrix
#' suppressWarnings(gene_corr <- cor(t(simNorm[1:30, ])))
#' gene_corr[is.na(gene_corr)] <- 0
#' 
#' # getting the PCIT correlation results for first 30 genes
#' results <- pcitC(cor = Matrix(gene_corr, sparse = TRUE), 
#'                 tolType = 1)
#' 
#' @rawNamespace useDynLib(CeTF)
#' @import Rcpp
#' @export
pcitC <- function(cor, tolType) {
    .Call('_CeTF_pcitC', PACKAGE = 'CeTF', cor, tolType)
}

