% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netConditionsPlot.R
\name{netConditionsPlot}
\alias{netConditionsPlot}
\title{Network plot of gene-gene/gene-TFs interactions}
\usage{
netConditionsPlot(x)
}
\arguments{
\item{x}{CeTF object resulted from \code{\link{runAnalysis}} function.}
}
\value{
Returns the network plot for both conditions.
}
\description{
Generate the network plot of gene-gene/gene-TFs interactions for both conditions.
}
\examples{
# loading a simulated counts data
data('simCounts')

# performing runAnalysis function
out <- runAnalysis(mat = simCounts,
                   conditions=c('cond1', 'cond2'),
                   lfc = 3,
                   padj = 0.05,
                   TFs = paste0('TF_', 1:1000),
                   nSamples1 = 10,
                   nSamples2= 10,
                   tolType = 'mean',
                   diffMethod = 'Reverter',
                   data.type = 'counts')

# plotting networks conditions
netConditionsPlot(out)



}
