% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-seqQc.R
\name{bc_seq_filter}
\alias{bc_seq_filter}
\alias{bc_seq_filter,ShortReadQ-method}
\alias{bc_seq_filter,DNAStringSet-method}
\alias{bc_seq_filter,data.frame-method}
\alias{bc_seq_filter,character-method}
\alias{bc_seq_filter,integer-method}
\alias{bc_seq_filter,list-method}
\title{Remove low-quality sequence}
\usage{
bc_seq_filter(
  x,
  min_average_quality = 30,
  min_read_length = 0,
  N_threshold = 0,
  sample_name = ""
)

\S4method{bc_seq_filter}{ShortReadQ}(
  x,
  min_average_quality = 30,
  min_read_length = 0,
  N_threshold = 0
)

\S4method{bc_seq_filter}{DNAStringSet}(x, min_read_length = 0, N_threshold = 0)

\S4method{bc_seq_filter}{data.frame}(x, min_read_length = 0, N_threshold = 0)

\S4method{bc_seq_filter}{character}(
  x,
  min_average_quality = 30,
  min_read_length = 0,
  N_threshold = 0,
  sample_name = basename(x)
)

\S4method{bc_seq_filter}{integer}(x, min_read_length = 0, N_threshold = 0)

\S4method{bc_seq_filter}{list}(
  x,
  min_average_quality = 30,
  min_read_length = 0,
  N_threshold = 0,
  sample_name = names(x)
)
}
\arguments{
\item{x}{A single or a list of Fastq file, \code{ShortReadQ},
\code{DNAStringSet}, \code{data.frame}, integer vector.}

\item{min_average_quality}{A numeric or a vector of numeric, specifying the
threshold of the minimum average base quality of a sequence to be kept.}

\item{min_read_length}{A single or a vector of integer, specifying the
sequence length threshold.}

\item{N_threshold}{A integer or a vector of integer, specifying the maximum
\code{N} can be in a sequence.}

\item{sample_name}{A string vector, specifying the sample name in the output.}
}
\value{
A ShortReadQ or DNAStringSet object with sequences passed the
filters.
}
\description{
Remove low-quality sequences by base-pair quality, sequence length or unknown
base "N".
}
\examples{
library(ShortRead)

fq_file <- system.file("extdata", "simple.fq", package="CellBarcode")

# apply a filter to fastq files
bc_seq_filter(fq_file)

# Read in fastq files to get ShortReadQ object
sr <- readFastq(fq_file[1])
# apply sequencing quality filter to ShortReadQ
bc_seq_filter(sr)

# get DNAStringSet object
ds <- sread(sr)
# Apply sequencing quality filter to DNAStringSet
bc_seq_filter(ds)

###
}
