% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherMetrics.R
\name{mixMetric}
\alias{mixMetric}
\title{mixMetric}
\usage{
mixMetric(
  sce,
  group,
  k = 300,
  dim_red = "PCA",
  assay_name = "logcounts",
  n_dim = 10,
  k_pos = 5,
  res_name = NULL
)
}
\arguments{
\item{sce}{\code{SingleCellExperiment} object, with the integrated data.}

\item{group}{Character. Name of group/batch variable.
Needs to be one of \code{names(colData(sce))}.}

\item{k}{Numeric. Number of k-nearest neighbours (knn) to use.}

\item{dim_red}{Character. Name of embeddings to use as subspace for distance
distributions. Default is "PCA".}

\item{assay_name}{Character. Name of the assay to use for PCA.
Only relevant if no existing 'dim_red' is provided.}

\item{n_dim}{Numeric. Number of dimensions to include to define the subspace.}

\item{k_pos}{Position of the cell, which rank to use for scoring,
defaults to 5.}

\item{res_name}{Character. Appendix of the result score's name
(e.g. method used to combine batches).}
}
\value{
A \code{SingleCellExperiment} with the mixing metric within colData.
}
\description{
mixMetric
}
\details{
The mixMetric function implements the mixingMetric function from
Seurat (See \code{\link[Seurat]{MixingMetric}}. It takes the median rank of
the '__k_pos__ neighbour from each batch as estimation for the data's entropy
according to the batch variable. The same result can be assesed using the
\code{\link[Seurat]{MixingMetric}} function and a seurat object from the
__Seurat__ package.
}
\examples{
library(SingleCellExperiment)
sim_list <- readRDS(system.file("extdata/sim50.rds", package = "CellMixS"))
sce <- sim_list[[1]][, c(1:15, 400:420, 16:30)]

sce <- mixMetric(sce, "batch", k = 20)
}
\references{
Stuart T Butler A Hoffman P Hafemeister C Papalexi E et. al. (2019)
Comprehensive Integration of Single-Cell Data.
Cell.
}
