% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisCms.R
\name{visOverview}
\alias{visOverview}
\title{visOverview}
\usage{
visOverview(
  sce_cms,
  group,
  metric = "cms",
  prefix = TRUE,
  dim_red = "TSNE",
  log10_val = FALSE,
  other_var = NULL,
  metric_prefix = NULL
)
}
\arguments{
\item{sce_cms}{A \code{SingleCellExperiment} object with the result scores
(e.g. cms) to plot in \code{colData(sce_cms)}.}

\item{group}{Character. Name of group/batch variable. Needs to be one of
\code{names(colData(sce))}.}

\item{metric}{Character vector. Specify names of \code{colData(sce)} to be
plotted. Applys only if `res_object` is a \code{SingleCellExperiment} object.
Default is 'cms'. If prefix is TRUE all columns starting with `metric` will
be plotted.}

\item{prefix}{Boolean. Is `metric` used to specify column's prefix(true) or
complete column names (False).}

\item{dim_red}{Character. Name of embeddings to use as subspace for plotting.
Default is "TSNE".}

\item{log10_val}{Logical. Indicating if -log10(metric) should be plotted.}

\item{other_var}{Character string. Name(s) of other variables to be plotted
asided. Need correspond to one of \code{colData(sce)}.}

\item{metric_prefix}{Former parameter to define prefix of the metric to be
plotted. Will stop and ask for the new syntax.}
}
\value{
a \code{ggplot} object.
}
\description{
Plot an overview of metric results, group label and any colData variable in
a reduced dimensional representation.
}
\details{
Plots reduced dimensions of cells colored by group variable and
metric score. If 'red_dim' is not defined in \code{reducedDimNames(sce)} a
tsne is calculated using \code{runTSNE}. Other color label as celltype label
or smoothened scores can be plotted aside. Embeddings from data integration
methods (e.g. mnn.correct) can be used if they are specified in
\code{reducedDimNames(sce)}.
}
\examples{
library(SingleCellExperiment)
sim_list <- readRDS(system.file("extdata/sim50.rds", package = "CellMixS"))
sce <- sim_list[[1]][, c(1:30, 300:330)]
sce_cms <- cms(sce, "batch", k = 20, n_dim = 2)

visOverview(sce_cms, "batch", other_var = "batch")


}
\seealso{
\code{\link{visMetric}}, \code{\link{visGroup}}

Other visualize metric functions: 
\code{\link{visHist}()},
\code{\link{visMetric}()}
}
\concept{visualize metric functions}
