% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-methods.R
\docType{methods}
\name{enrichment.test}
\alias{enrichment.test}
\title{Enrichment test}
\usage{
enrichment.test(
  sample_true,
  sample_size,
  pop_true,
  pop_size,
  method = c("fisher", "hyper")
)
}
\arguments{
\item{sample_true}{Number of hits in sample}

\item{sample_size}{Size of sample}

\item{pop_true}{Number of hits in population}

\item{pop_size}{Size of population}

\item{method}{Statistical method that should be used}
}
\value{
A list containing the following components:
  \item{\code{p.value}}{P-value of the test}
  \item{\code{odds.ratio}}{Odds ratio}
  \item{\code{conf.int}}{Confidence interval for the odds ratio
  (only shown with method="fisher")}
  \item{\code{method}}{Used statistical test}
}
\description{
Statistical enrichment analysis using either a Hypergeometric
or Fisher's test
}
\details{
Hypergeometric or one-tailed Fisher exact test is
useful for enrichment analyses.
For example, one needs to estimate which features
are enriched among
a set of instances sampled from a population.
}
\examples{
# Population has 13 of total 52 instances positive for a given feature
# Sample has 1 of total 5 instances positive for a given feature
# Test for significance of enrichment in sample
enrichment.test(sample_true=1, sample_size=5,
                pop_true=13, pop_size=52, method="fisher")
}
\seealso{
\code{Hypergeometric} and \code{fisher.test}
}
\author{
Daniel C. Ellwanger
}
