% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{findSpectrum}
\alias{findSpectrum}
\alias{findSpectrum,numeric-method}
\title{Determine number of informative latent dimensions}
\usage{
findSpectrum(x, frac = 100)
}
\arguments{
\item{x}{A numeric vector with eigenvalues}

\item{frac}{Fraction or number (if \code{frac > 1}) of eigengaps
used to perform linear fit. (default: 100)}
}
\value{
A \code{numeric} vector with indices of relevant dimensions
}
\description{
Identifies the dimensionality of the latent space
}
\details{
Similar to a scree plot, this method generates a simple line
segement plot showing the lagged differences between ordered eigenvalues
(eigengaps). A linear fit is calucated on a fraction of top ranked values
to identify informative eigenvectors.
}
\examples{
# Example data
data(exSCE)

# Embedding
res <- embedSamples(exSCE)

# Find spectrum
d <- findSpectrum(res$eigenvalues, frac=30)
d
}
\seealso{
\code{pca} \code{embedSamples}
}
\author{
Daniel C. Ellwanger
}
