\name{plotcexor}
\alias{plotcexor}

\title{ Visualization of ChIP-exo peak-pair calling with replicates }
\description{ Visualization of ChIP-exo peak-pair calling with replicates. }

\usage{
  plotcexor(bam, peaks, EXT=500)
}

\arguments{
  \item{bam}{ BAM alignment files of biological replicates. }
  \item{peaks}{ Object (list) output of the function 'cexor'.}
  \item{EXT}{ Extension (bp) upstream and downstream the central position of reproducible peak pair locations for visulization purposes.}
}

\details{ Visualization of ChIP-exo peak-pair calling with replicates.}

\value{
  R plot.
}

\references{ Madrigal P (2015) CexoR: an R/Bioconductor package to uncover high-resolution protein-DNA interactions in ChIP-exo replicates. EMBnet.journal  21: e837.  }

\author{ Pedro Madrigal, \email{pmadrigal@ebi.ac.uk} }

\seealso{ \code{\link{CexoR-package}} }

\examples{

  ## hg19. chr2:1-1,000,000. CTCF data from Rhee and Pugh (2011)
  owd <- setwd(tempdir())

  rep1 <- "CTCF_rep1_chr2_1-1e6.bam"
  rep2 <- "CTCF_rep2_chr2_1-1e6.bam"
  rep3 <- "CTCF_rep3_chr2_1-1e6.bam"
  r1 <- system.file("extdata", rep1, package="CexoR",mustWork = TRUE)
  r2 <- system.file("extdata", rep2, package="CexoR",mustWork = TRUE)
  r3 <- system.file("extdata", rep3, package="CexoR",mustWork = TRUE)

  chipexo <- cexor(bam=c(r1,r2,r3), chrN="chr2", chrL=1e6, idr=0.01, p=1e-12, N=3e4)

  plotcexor(bam=c(r1,r2,r3), peaks=chipexo, EXT=500)

  setwd(owd)

}
