% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{CompareedgeRGLM}
\alias{CompareedgeRGLM}
\title{Creates a summary table with the number of genes under- or overexpressed in
each group and outputs several graphical representations}
\usage{
CompareedgeRGLM(
  dataMat = NULL,
  annot = NULL,
  ref_group = NULL,
  groups = NULL,
  featureTab = NULL,
  norm_method = "TMMwsp"
)
}
\arguments{
\item{dataMat}{reads matrix}

\item{annot}{selected annotation of interest}

\item{ref_group}{List containing one or more vectors of reference samples.
Name of the vectors will be used in the results table. The length of this
list should be 1 or the same length as the groups list}

\item{groups}{List containing the IDs of groups to be compared with the
reference samples. Names of the vectors will be used in the results table}

\item{featureTab}{Feature annotations to be added to the results table}

\item{norm_method}{Which method to use for normalizing ('upperquantile')}
}
\value{
A dataframe containing the foldchange and p.value of each feature
}
\description{
Creates a summary table with the number of genes under- or overexpressed in
each group and outputs several graphical representations
}
\examples{
data("scExp")
scExp_cf = correlation_and_hierarchical_clust_scExp(scExp)
scExp_cf = choose_cluster_scExp(scExp_cf,nclust=2,consensus=FALSE)
featureTab = as.data.frame(SummarizedExperiment::rowRanges(scExp_cf))
rownames(featureTab) = featureTab$ID
ref_group = list("C1"=scExp_cf$cell_id[which(scExp_cf$cell_cluster=="C1")])
groups = list("C2"=scExp_cf$cell_id[which(scExp_cf$cell_cluster=="C2")])
myres = CompareedgeRGLM(as.matrix(SingleCellExperiment::counts(scExp_cf)),
annot=as.data.frame(SingleCellExperiment::colData(scExp_cf)),
   ref_group=ref_group,groups=groups, featureTab=featureTab)

}
\author{
Eric Letouze & Celine Vallot
}
