% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_heatmap_scExp}
\alias{plot_heatmap_scExp}
\title{Plot cell correlation heatmap with annotations}
\usage{
plot_heatmap_scExp(
  scExp,
  name_hc = "hc_cor",
  corColors = (grDevices::colorRampPalette(c("royalblue", "white", "indianred1")))(256),
  color_by = NULL,
  downsample = 1000,
  hc_linkage = "ward.D"
)
}
\arguments{
\item{scExp}{A SingleCellExperiment Object}

\item{name_hc}{Name of the hclust contained in the SingleCellExperiment
object}

\item{corColors}{A palette of colors for the heatmap}

\item{color_by}{Which features to add as additional bands on top of plot}

\item{downsample}{Number of cells to downsample}

\item{hc_linkage}{A linkage method for hierarchical clustering. See
\link[stats]{cor}. ('ward.D')}
}
\value{
A heatmap of cell to cell correlation, grouping cells by hierarchical
clustering.
}
\description{
Plot cell correlation heatmap with annotations
}
\examples{
data("scExp")
plot_heatmap_scExp(scExp)

}
