% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_most_contributing_features}
\alias{plot_most_contributing_features}
\title{Plot Top/Bottom most contributing features to PCA}
\usage{
plot_most_contributing_features(
  scExp,
  component = "Component_1",
  n_top_bot = 10
)
}
\arguments{
\item{scExp}{A SingleCellExperiment containing "PCA" in reducedDims and gene
annotation in rowRanges}

\item{component}{The name of the component of interest}

\item{n_top_bot}{An integer number of top and bot regions to plot}
}
\value{
A barplot of top and bottom features with the largest absolute
value in the component of interest
}
\description{
Plot Top/Bottom most contributing features to PCA
}
\details{
If a gene TSS is within 10,000bp of the region, the name of the gene(s) will
be displayed instead of the region
}
\examples{
data(scExp)
plot_most_contributing_features(scExp, component = "Component_1")
}
